package net.w_horse.excelpojo.converter;

import static org.junit.Assert.assertEquals;

import java.text.ParseException;
import java.text.SimpleDateFormat;

import org.junit.Test;

import net.w_horse.excelpojo.AbstractTest;
import net.w_horse.excelpojo.ExcelPOJOException;

public class StringDateConverterTest extends AbstractTest {

	/**
	 * ftHg̕ϊ
	 * @throws ExcelPOJOException
	 */
	@Test
	public void testDefault() throws ExcelPOJOException {
		StringDateConverter converter = new StringDateConverter();
		assertEquals("20100806", converter.convertCell2Field("2010/8/6"));

		assertEquals("2010/8/6", converter.convertField2Cell("20100806"));
	}

	/**
	 * Date̕ϊ
	 * @throws ExcelPOJOException
	 * @throws ParseException
	 */
	@Test
	public void testString2Date() throws ExcelPOJOException, ParseException {
		StringDateConverter converter = new StringDateConverter();
		converter.setFieldType("java.util.Date");

		assertEquals((new SimpleDateFormat("yyyy-MM-dd").parse("2010-08-06")),
				converter.convertCell2Field("2010/8/6"));

		assertEquals("2010/8/6", converter.convertField2Cell(
				(new SimpleDateFormat("yyyy-MM-dd").parse("2010-08-06"))));
	}

	/**
	 * ̕̕ϊ
	 * @throws ExcelPOJOException
	 */
	@Test
	public void testString2String() throws ExcelPOJOException {
		StringDateConverter converter = new StringDateConverter();
		converter.setFieldFormat("yyyyNMMdd");
		assertEquals("2010N0806", converter.convertCell2Field("2010/8/6"));

		assertEquals("2010/8/6", converter.convertField2Cell("2010N0806"));
	}

	/**
	 * Date̕̕ϊ
	 * @throws ExcelPOJOException
	 * @throws ParseException
	 */
	@Test
	public void testDate2String() throws ExcelPOJOException, ParseException {
		StringDateConverter converter = new StringDateConverter();
		converter.setCellType("java.util.Date");

		assertEquals("20100806",converter.convertCell2Field(
				(new SimpleDateFormat("yyyy-MM-dd").parse("2010-08-06"))));

		assertEquals((new SimpleDateFormat("yyyy-MM-dd").parse("2010-08-06")),
				converter.convertField2Cell("20100806"));
	}
}
